<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) <2016>  <jamelbaz@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\file		class/myclass.class.php
 * 	\ingroup	mymodule
 * 	\brief		This file is an example CRUD class file (Create/Read/Update/Delete)
 * 				Put some comments here
 */
// Put here all includes required by your class file
//require_once DOL_DOCUMENT_ROOT."/core/class/commonobject.class.php";
//require_once DOL_DOCUMENT_ROOT."/societe/class/societe.class.php";
//require_once DOL_DOCUMENT_ROOT."/product/class/product.class.php";

/**
 * Put your class' description here
 */
class Dolimaps // extends CommonObject
{

	private $db; //!< To store db handler
	public $error; //!< To return error code (or message)
	public $errors = array(); //!< To return several error codes (or messages)
	//public $element='skeleton';	//!< Id that identify managed objects
	//public $table_element='skeleton';	//!< Name of table without prefix where object is stored
	public $id;
	public $lng;
	public $lat;
	public $element;
	public $element_id;

	/**
	 * Constructor
	 *
	 * 	@param	DoliDb		$db		Database handler
	 */
	public function __construct($db)
	{
		$this->db = $db;

		return 1;
	}

	/**
	 * Create object into database
	 *
	 * 	@param		User	$user		User that create
	 * 	@param		int		$notrigger	0=launch triggers after, 1=disable triggers
	 * 	@return		int					<0 if KO, Id of created object if OK
	 */
	
	function add($user,$notrigger=0)
    {

        $this->db->begin();

        $sql = "INSERT INTO ".MAIN_DB_PREFIX."dm_geolocation";
        $sql.= "(title,lng,";
        $sql.= "lat";
		
		if(!empty($this->element)){			
			$sql.= ",element,";
			$sql.= "element_id";
		}
        
        $sql.= ") VALUES (";
        $sql.= "'" . $this->title . "',";
        $sql.= $this->lng . ",";
        $sql.= $this->lat . "";
		
		if(!empty($this->element)){			
			$sql.= ",'" . $this->element . "',";
			$sql.= $this->element_id . ""; 
		}
		
        $sql.= ")";
		
        dol_syslog(get_class($this)."::add", LOG_DEBUG);
        $resql=$this->db->query($sql);
		
        if ($resql)
        {	
			$this->db->commit();
			return 1;
        }
        else
        {
            $this->db->rollback();
            $this->error=$this->db->lasterror();
            return -1;
        }

    }

	/**
	 * Load object in memory from database
	 *
	 * 	@param		int		$id	Id object
	 * 	@return		int			<0 if KO, >0 if OK
	 */
    /**
     *    Load object from database
     *
     *    @param	int		$id     	Id of action to get
     *    @param	string	$ref    	Ref of action to get
     *    @param	string	$ref_ext	Ref ext to get
     *    @return	int					<0 if KO, >0 if OK
     */
    function fetchAll($element)
    {
        global $langs;

        $sql = "SELECT rowid,title,";
        $sql.= " lng,";
        $sql.= " lat,";
        $sql.= " element,";
        $sql.= " element_id ";
        $sql.= " FROM ".MAIN_DB_PREFIX."dm_geolocation ";
		
		if(empty($element)){
			$sql.= " WHERE element IS NULL";
		}else{
			$sql.= " WHERE element = '$element'";
		}
		
		

        dol_syslog(get_class($this)."::fetch", LOG_DEBUG);
        $resql=$this->db->query($sql);
		if ($resql) {
			$i = 0;
			$obj = '';
			$num = $this->db->num_rows($resql);
			$data = array();
			if ($num) {
				while ( $i < $num ) {
					
					$obj = $this->db->fetch_object($resql);
					
					$name_cat = $obj->name_cat;
					
					$data[$i] =	array(
									'id' => $obj->rowid,
									'title' => $obj->title,
									'lng' => $obj->lng,
									'lat' => $obj->lat,
									'element' => $obj->element,
									'element_id' => $obj->element_id,
									);
					
					$i ++;
				}
			}
			
			return $data;
		} else {
			$this->error = "Error " . $this->db->lasterror();
			dol_syslog(__METHOD__ . " " . $this->error, LOG_ERR);

			return -1;
		}

    }



	/**
	 * Delete object in database
	 *
	 * 	@param		User	$user		User that delete
	 * 	@param		int		$notrigger	0=launch triggers after, 1=disable triggers
	 * 	@return		int					<0 if KO, >0 if OK
	 */
	public function delete($user, $notrigger = 0)
	{
		global $conf, $langs;
		$error = 0;

		$this->db->begin();



		if (! $error) {
			$sql = "DELETE FROM " . MAIN_DB_PREFIX . "dm_geolocation";
			$sql.= " WHERE rowid=" . $this->id;
			
			dol_syslog(__METHOD__ . " sql=" . $sql);
			$resql = $this->db->query($sql);
			if (! $resql) {
				$error ++;
				$this->errors[] = "Error " . $this->db->lasterror();
			}
		}

		// Commit or rollback
		if ($error) {
			foreach ($this->errors as $errmsg) {
				dol_syslog(__METHOD__ . " " . $errmsg, LOG_ERR);
				$this->error.=($this->error ? ', ' . $errmsg : $errmsg);
			}
			$this->db->rollback();

			return -1 * $error;
		} else {
			$this->db->commit();

			return 1;
		}
	}
	
	
	/*
	*	Get html 
	*****/
	
	public function gethtml($title, $element, $element_id, $location_id)
	{
		
		if($element == 'clients' || $element == 'prospects' || $element == 'fournisseurs'){
			
			$sql = "SELECT rowid,";
			$sql.= " nom,";
			$sql.= " phone,";
			$sql.= " email ";
			$sql.= " FROM ".MAIN_DB_PREFIX."societe ";
			$sql.= " WHERE rowid = $element_id";
			
			dol_syslog(__METHOD__ . " sql=" . $sql, LOG_DEBUG);
			$resql = $this->db->query($sql);
			if ($resql) {
				$html = "";
				if ($this->db->num_rows($resql)) {
					$obj = $this->db->fetch_object($resql);
					$html = "<p> <b>" . $obj->nom . " </b> | " . $obj->phone . " | " . $obj->email . "</p>";
					$html .= '<a class="delete" href="' . $_SERVER['PHP_SELF'] . '?action=delete&element=' . $element . '&id=' . $location_id . '">' . img_delete() . '</a>';
					
				}
				//$this->db->free($resql);
				return $html;
			}
			
		}elseif($element == 'contacts'){
			
			$sql = "SELECT rowid,";
			$sql.= " lastname,";
			$sql.= " firstname,";
			$sql.= " phone,";
			$sql.= " email ";
			$sql.= " FROM ".MAIN_DB_PREFIX."socpeople ";
			$sql.= " WHERE rowid = $element_id";
			
			dol_syslog(__METHOD__ . " sql=" . $sql, LOG_DEBUG);
			$resql = $this->db->query($sql);
			if ($resql) {
				$html = "";
				if ($this->db->num_rows($resql)) {
					$obj = $this->db->fetch_object($resql);
					$html = "<p> <b>" . $obj->lastname . " " . $obj->firstname . "</b> | " . $obj->phone . " | " . $obj->email . "</p>";
					$html .= '<a class="delete" href="' . $_SERVER['PHP_SELF'] . '?action=delete&element=produits&id=' . $location_id . '">' . img_delete() . '</a>';
					
				}
				//$this->db->free($resql);
				return $html;
			}
			
			
		}elseif($element == 'produits'){
			
			$sql = "SELECT rowid,";
			$sql.= " ref,";
			$sql.= " label,";
			$sql.= " price_ttc ";
			$sql.= " FROM ".MAIN_DB_PREFIX."product ";
			$sql.= " WHERE rowid = $element_id";
			
			dol_syslog(__METHOD__ . " sql=" . $sql, LOG_DEBUG);
			$resql = $this->db->query($sql);
			if ($resql) {
				$html = "";
				if ($this->db->num_rows($resql)) {
					$obj = $this->db->fetch_object($resql);
					$html = "<p> <b>" . $obj->label . " (" . $obj->ref . ") | " . price($obj->price_ttc) . "</b> </p>";
					$html .= '<a class="delete" href="' . $_SERVER['PHP_SELF'] . '?action=delete&element=produits&id=' . $location_id . '">' . img_delete() . '</a>';
					
				}
				//$this->db->free($resql);
				return $html;
			}
			
			
		}else{
			$html = "<p>$title</p>";
			$html .= '<a class="delete" href="' . $_SERVER['PHP_SELF'] . '?action=delete&element=autre&id=' . $location_id . '">' . img_delete() . '</a>';
			return $html;
		}
		
	}
	
	/*
	*	Get Conf
	*****/
	
	public function getConf()
	{
		global $langs;
		$sql = "SELECT rowid,";
        $sql.= " lng,";
        $sql.= " lat,";
        $sql.= " zoom ";
        $sql.= " FROM ".MAIN_DB_PREFIX."dm_conf ";
		$sql.= " WHERE rowid = 1";
		
		dol_syslog(__METHOD__ . " sql=" . $sql, LOG_DEBUG);
		$resql = $this->db->query($sql);
		if ($resql) {
			$data = array();
			if ($this->db->num_rows($resql)) {
				$obj = $this->db->fetch_object($resql);
				
				$data =	array(
							'id' => $obj->id,
							'zoom' => $obj->zoom,
							'lng' => $obj->lng,
							'lat' => $obj->lat,
							);
			}
			$this->db->free($resql);
			return $data;
		} else {
			$this->error = "Error " . $this->db->lasterror();
			dol_syslog(__METHOD__ . " " . $this->error, LOG_ERR);
			return -1;
		}
	}
	
	public function updateConf($lat, $lng, $zoom)
	{
		

		// Check parameters
		// Put here code to add control on parameters values
		// Update request
		$sql = "UPDATE " . MAIN_DB_PREFIX . "dm_conf SET";
		$sql.= " lat = $lat, lng = $lng, zoom = $zoom";

		$sql.= " WHERE rowid = 1";

		$this->db->begin();

		dol_syslog(__METHOD__ . " sql=" . $sql, LOG_DEBUG);
		$resql = $this->db->query($sql);
		if (! $resql) {
			$error ++;
			$this->errors[] = "Error " . $this->db->lasterror();
		}


		// Commit or rollback
		if ($error) {
			foreach ($this->errors as $errmsg) {
				dol_syslog(__METHOD__ . " " . $errmsg, LOG_ERR);
				$this->error.=($this->error ? ', ' . $errmsg : $errmsg);
			}
			$this->db->rollback();

			return -1 * $error;
		} else {
			$this->db->commit();

			return 1;
		}
	}
	


}
