<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) <2016>  <jamelbaz@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


// Load Dolibarr environment
$res = @include ("../main.inc.php"); // For root directory
if (! $res)
	$res = @include ("../../main.inc.php"); // For "custom" directory
if (! $res)
	die("Include of main fails");

dol_include_once('/dolimaps/class/dolimaps.class.php');

	$location = new Dolimaps($db);
    
$langs->load('dolimaps@dolimaps');



/************************/
$id = GETPOST('id', 'int');
$action = GETPOST('action', 'alpha');
$element = GETPOST('element');
$title = GETPOST('title');





$lat = GETPOST('lat');
$lng = GETPOST('lng');

/*
 * Confirmation de la suppression
 */
if ($action == 'delete') {
	
	$location->id = $id;
	$result = $location->delete($user);
	
	if ($result > 0) {
		setEventMessage($langs->trans("Deleted"), 'mesgs');
	} else {	
		setEventMessage($langs->trans("NotDeleted"), 'errors');
	}
}

if($action == "add"){
	
	$location->lat = $lat;
	$location->lng = $lng;
	$error = 0;
	
	if($element == "clients"){
		$location->element = "clients";
		$location->element_id = GETPOST('socid');
		if (GETPOST("socid") == -1) {
			setEventMessage($langs->trans('FieldIsClient'), 'errors');
			$error ++;
		}
	}elseif($element == "prospects"){
		$location->element = "prospects";
		$location->element_id = GETPOST('socid');
		if (GETPOST("socid") == -1) {
			setEventMessage($langs->trans('FieldIsProspect'), 'errors');
			$error ++;
		}
	}elseif($element == "fournisseurs"){
		$location->element = "fournisseurs";
		$location->element_id = GETPOST('socid');
		if (GETPOST("socid") == -1) {
			setEventMessage($langs->trans('FieldIsFournisseur'), 'errors');
			$error ++;
		}
	}elseif($element == "contacts"){
		$location->element = "contacts";
		$location->element_id = GETPOST('contactid');
		if (GETPOST("contactid") == 0) {
			setEventMessage($langs->trans('FieldIsContactid'), 'errors');
			$error ++;
		}
	}elseif($element == "produits"){
		$location->element = "produits";
		$location->element_id = GETPOST('idprod');
		if (GETPOST("idprod") == 0 || empty(GETPOST("idprod"))) {
			setEventMessage($langs->trans('FieldIsProduit'), 'errors');
			$error ++;
		}
	}else{
		$location->title = $title;
		if (empty($title)) {
			setEventMessage($langs->trans('FieldIsTitle'), 'errors');
			$error ++;
		}
	}
	if (! $error)
	{
		$idaction=$location->add($user);

		if ($idaction > 0) {
			$lat = '';
			$lng = '';
			setEventMessage($langs->trans("Added"), 'mesgs');
		} else {	
			setEventMessage($langs->trans("NotAdded"), 'errors');
		}
	}
}



$locations = array();

if($element == "clients"){
	$locations = $location->fetchAll("clients");
}elseif($element == "prospects"){
	$locations = $location->fetchAll("prospects");
}elseif($element == "fournisseurs"){
	$locations = $location->fetchAll("fournisseurs");
}elseif($element == "contacts"){
	$locations = $location->fetchAll("contacts");
}elseif($element == "produits"){
	$locations = $location->fetchAll("produits");
}else{	
	$locations = $location->fetchAll("");
}

if($locations == -1){
	$locations = array();
}

$config = $location->getConf();

$morejs=array("https://maps.googleapis.com/maps/api/js?key=AIzaSyCdDOmRSMFKS0mWO3L90B0IPvS2oinxZiw","/dolimaps/js/gmaps.min.js");
llxHeader('',$langs->trans('Geolocation'),'','','','',$morejs,'',0,0);

?>

    <div data-role="page" id="index">
    
        <div data-role="header">
            <h1><img src="<?php print dol_buildpath('dolimaps/img/geolocation.png', 1);?>"> <?php print $langs->trans("Geolocation");?></h1>
			
			
			
        </div><!-- /header -->
        
        <div data-role="content">       
           <div id="map" style=" width: 100%; height: 450px;"></div>
        </div><!-- /content -->
		
		
		<form action="<?php print $_SERVER["PHP_SELF"]; ?>" method="post">
			<input type="hidden" name="token" value="<?php print $_SESSION['newtoken']; ?>">
			<input type="hidden" name="action" value="add">
			
			<div class="tabs" data-role="controlgroup" data-type="horizontal">
			</div>

			<div class="tabBar">
				<table class="border" width="100%">
					<tr>
						<td>
						<?php echo $langs->trans("latitude");?>
						</td>
						<td>
						<input type="text" name="lat" id="lat" size="16" value="<?php echo $lat;?>">
						</td>
						<td>
						<?php echo $langs->trans("longitude");?>
						</td>
						<td>
						<input type="text" name="lng" id="lng" size="16" value="<?php echo $lng;?>">
						</td>
						<?php 							
							if($element == "clients"){	
								print '<input type="hidden" name="element" value="clients">';
								print "<td>".$langs->trans("Customer")."</td>";
								print "<td>".$form->select_company('', 'socid', 's.client = 1', 1)."</td>";
							}elseif($element == "prospects"){
								print '<input type="hidden" name="element" value="prospects">';
								print "<td>".$langs->trans("Prospect")."</td>";
								print "<td>".$form->select_company('', 'socid', 's.client = 2', 1)."</td>";
							}elseif($element == "contacts"){								
								print '<input type="hidden" name="element" value="contacts">';
								print '<td>'.$langs->trans("Contact").'</td><td>';
								print '<div class="maxwidth200onsmartphone">';
								$form->select_contacts($object->socid, $object->contactid, 'contactid', 1, '', '', 0, 'minwidth200');
								print '</div>';
								print '</td>';
								
							}elseif($element == "fournisseurs"){		
								print '<input type="hidden" name="element" value="fournisseurs">';
								print "<td>".$langs->trans("Provider")."</td>";
								print "<td>".$form->select_company('', 'socid', 's.fournisseur = 1', 1)."</td>";
							}elseif($element == "produits"){		
								print '<input type="hidden" name="element" value="produits">';
								print "<td>".$langs->trans("Product")."</td>";
								
								print '<td>';
								if (! empty($conf->global->PRODUIT_MULTIPRICES))
									$form->select_produits('', 'idprod', '', $conf->product->limit_size, $soc->price_level);
								else
									$form->select_produits('', 'idprod', '', $conf->product->limit_size);
								print '</td>';
								
								/*print "<td>".$langs->trans("Product")."</td>";
								print "<td>".$form->select_produits('', 'idprod', '', $conf->product->limit_size)."</td>";*/
							}else{
								print "<td>".$langs->trans("Title")."</td>";
								print "<td><input type='text' name='title' id='title' value=''></td>";
							}
						?>
					</tr>
				</table>
					
			</div>
			<div class="center"><input type="submit" class="button" name="create" value="<?php echo $langs->trans("AddLocation");?>"></div>
			<input type='hidden' id='confirmMsg' value='<?php echo $langs->trans("ConfirmDelete");?>'>
		</form>
    </div><!-- /page -->
	
	
	
  <script type="text/javascript" charset="UTF-8">
    var map;
	var locs = [
		<?php foreach($locations as $local): ?>
			{
				lat: <?php echo $local['lat']; ?>,
				lng: <?php echo $local['lng']; ?>,
				<?php if(!empty($local['title'])){ echo "title: '".$local['element']."'"; }else{echo "title: ''";} ?>,
				infoWindow: {
					content: '<?php echo $location->gethtml($local['title'], $local['element'], $local['element_id'], $local['id']); ?>'
				},
		
			},
		<?php endforeach; ?>
	];
	
	$(document).ready(function(){
		map = new GMaps({
			div: '#map',
			lat: <?php echo $config['lat']; ?>,
			lng: <?php echo $config['lng']; ?>,
			zoom: <?php echo $config['zoom']; ?>,
		});

		map.addMarkers(locs);

		GMaps.on('click', map.map, function(event) {
			var index = map.markers.length;
			var lat = event.latLng.lat();
			var lng = event.latLng.lng();

			$("#lat").val(lat);
			$("#lng").val(lng);
			var content = "teste";

			map.addMarker({
				lat: lat,
				lng: lng,
				draggable: true,
				title: 'Marker #' + index,
				dragend: function(event) {
					var lat = event.latLng.lat();
					var lng = event.latLng.lng();
					$("#lat").val(lat);
					$("#lng").val(lng);
				}
			});
		});
	  	
	});
	
	$("#map").on("click", ".delete", function(e) {
		e.preventDefault();
		var r=confirm($("#confirmMsg").val());
		if (r==true)   {  
			window.location = $(this).attr('href');
		}

	});

  </script>
  

<?php llxFooter();?>